/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.entity.data.IAnimation;
import noppes.npcs.api.event.AnimationEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.client.model.animation.AnimationFrameConfig;
import noppes.npcs.client.model.animation.PartConfig;
import noppes.npcs.constants.EnumAnimationStages;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;
import noppes.npcs.util.ValueUtil;

public class AnimationHandler {
    private final EntityLivingBase entity;
    public final Map<Integer, Float[]> rotationAngles = new TreeMap<Integer, Float[]>();
    private final Map<AnimationKind, List<Integer>> data = new HashMap<AnimationKind, List<Integer>>();
    private final Map<Integer, Long> waitData = new HashMap<Integer, Long>();
    public AnimationConfig activeAnimation = null;
    public final Map<AnimationKind, Integer> movementAnimation = new HashMap<AnimationKind, Integer>();
    public long startAnimationTime = 0L;
    public EnumAnimationStages stage = EnumAnimationStages.Waiting;
    private boolean completeAnimation = false;
    private ResourceLocation animationSound = null;
    public boolean isCyclical = false;
    private boolean canSetBaseRotationAngles = true;
    private int timeTicks = -1;
    private int speedTicks = -1;
    public final AnimationFrameConfig preFrame = new AnimationFrameConfig();
    public AnimationFrameConfig currentFrame;
    public AnimationFrameConfig nextFrame;
    public boolean isJump = false;
    public boolean isSwing = false;
    private final Random rnd = new Random();

    public AnimationHandler(EntityLivingBase main) {
        this.entity = main;
        this.checkData();
    }

    public boolean hasAnim(AnimationKind type) {
        if (!this.data.containsKey((Object)type) || this.data.get((Object)type) == null || this.data.get((Object)type).isEmpty()) {
            return false;
        }
        AnimationController aData = AnimationController.getInstance();
        for (int id : this.data.get((Object)type)) {
            if (!aData.animations.containsKey(id)) continue;
            return true;
        }
        return false;
    }

    private void checkData() {
        for (AnimationKind type : AnimationKind.values()) {
            if (this.data.containsKey((Object)type)) continue;
            this.data.put(type, new ArrayList());
        }
        while (this.data.containsKey(null)) {
            this.data.remove(null);
        }
    }

    public void stopAnimation() {
        if (this.activeAnimation != null) {
            if (this.activeAnimation.type != AnimationKind.EDITING_All && this.activeAnimation.type != AnimationKind.EDITING_PART) {
                int ticks = (int)(this.entity.field_70170_p.func_82737_E() - this.startAnimationTime);
                int animationFrame = this.activeAnimation.getAnimationFrameByTime(ticks);
                int startFrameTime = 0;
                if (this.activeAnimation.endingFrameTicks.containsKey(animationFrame - 1)) {
                    startFrameTime = this.activeAnimation.endingFrameTicks.get(animationFrame - 1);
                }
                this.startEvent(new AnimationEvent.StopEvent(this.entity, this.activeAnimation, animationFrame, ticks - startFrameTime, this.stage));
            } else {
                return;
            }
        }
        if (this.animationSound != null && !this.entity.func_70613_aW()) {
            MusicController.Instance.stopSound(this.animationSound.toString(), SoundCategory.AMBIENT);
        }
        this.animationSound = null;
        this.startAnimationTime = 0L;
        this.completeAnimation = false;
        this.activeAnimation = null;
        this.stage = EnumAnimationStages.Waiting;
        this.isJump = false;
        this.isSwing = false;
        this.canSetBaseRotationAngles = true;
        this.timeTicks = -1;
        this.speedTicks = -1;
    }

    public void calculationAnimationData(float partialTicks) {
        float correctorRotations;
        if (this.stage == EnumAnimationStages.Waiting || this.activeAnimation == null) {
            return;
        }
        int ticks = Math.max(0, (int)(this.entity.field_70170_p.func_82737_E() - this.startAnimationTime));
        if (this.activeAnimation.type == AnimationKind.EDITING_PART) {
            partialTicks = 0.0f;
            ticks = this.activeAnimation.editTick;
            if (this.activeAnimation.editFrame > 0) {
                ticks += this.activeAnimation.endingFrameTicks.get(this.activeAnimation.editFrame - 1).intValue();
            }
        }
        this.speedTicks = this.activeAnimation.type.isQuickStart() ? 4 : 10;
        boolean isEdit = this.activeAnimation.type == AnimationKind.EDITING_All || this.activeAnimation.type == AnimationKind.EDITING_PART;
        switch (this.stage) {
            case Started: {
                this.currentFrame = this.preFrame;
                this.nextFrame = this.activeAnimation.frames.get(0);
                if (!this.activeAnimation.type.isMovement()) break;
                this.speedTicks = this.nextFrame.speed;
                break;
            }
            case Looping: {
                this.currentFrame = this.activeAnimation.frames.get(this.activeAnimation.frames.size() - 1);
                int lastFrameId = this.activeAnimation.frames.size();
                int frameId = 0;
                if (this.activeAnimation.repeatLast > 0) {
                    frameId = ValueUtil.correctInt(lastFrameId - this.activeAnimation.repeatLast, 0, lastFrameId - 1);
                } else if (this.activeAnimation.type == AnimationKind.DIES) {
                    frameId = lastFrameId - 1;
                }
                this.nextFrame = this.activeAnimation.frames.get(frameId);
                this.speedTicks = this.currentFrame.speed;
                break;
            }
            case Run: {
                int animationFrame = this.activeAnimation.getAnimationFrameByTime(ticks);
                if (animationFrame < 0) {
                    animationFrame = 0;
                }
                this.currentFrame = this.activeAnimation.frames.get(animationFrame);
                if (this.currentFrame == null) {
                    if (this.activeAnimation.frames.isEmpty()) {
                        this.stopAnimation();
                        return;
                    }
                    animationFrame = 0;
                    this.currentFrame = this.activeAnimation.frames.get(animationFrame);
                }
                this.nextFrame = this.activeAnimation.frames.get(Math.min(animationFrame + 1, this.activeAnimation.frames.size() - 1));
                this.speedTicks = this.currentFrame.speed;
                if (!this.activeAnimation.endingFrameTicks.containsKey(animationFrame - 1)) break;
                ticks -= this.activeAnimation.endingFrameTicks.get(animationFrame - 1).intValue();
                break;
            }
            case Ending: {
                this.currentFrame = this.activeAnimation.frames.get(this.activeAnimation.frames.size() - 1);
                this.nextFrame = this.preFrame;
                break;
            }
            default: {
                this.stopAnimation();
            }
        }
        this.timeTicks = ticks;
        if (this.nextFrame.id != -1 && this.currentFrame.id == -1) {
            for (int id : this.nextFrame.parts.keySet()) {
                if (!this.currentFrame.parts.containsKey(id)) continue;
                this.currentFrame.parts.get(id).setDisable(this.nextFrame.parts.get(id).isDisable());
                this.currentFrame.parts.get(id).setShow(this.nextFrame.parts.get(id).isShow());
            }
        }
        if (this.nextFrame.id == -1 && this.currentFrame.id != -1) {
            for (int id : this.nextFrame.parts.keySet()) {
                if (!this.nextFrame.parts.containsKey(id)) continue;
                this.nextFrame.parts.get(id).setDisable(this.currentFrame.parts.get(id).isDisable());
                this.nextFrame.parts.get(id).setShow(this.currentFrame.parts.get(id).isShow());
            }
        }
        float f = correctorRotations = !this.activeAnimation.type.isMovement() ? 1.0f : Util.instance.getCurrentXZSpeed(this.entity);
        if (this.animationSound == null && this.currentFrame.sound != null && !isEdit && !this.entity.func_70613_aW() && this.entity.field_70170_p.field_72996_f.contains(this.entity)) {
            MusicController.Instance.playSound(SoundCategory.AMBIENT, this.currentFrame.sound.toString(), (float)this.entity.field_70165_t, (float)this.entity.field_70163_u, (float)this.entity.field_70161_v, 1.0f, 1.0f);
            this.animationSound = this.currentFrame.sound;
        }
        this.rotationAngles.clear();
        if (this.currentFrame.delay != 0) {
            ticks -= this.currentFrame.delay;
        }
        for (int partId = 0; partId < this.currentFrame.parts.size(); ++partId) {
            PartConfig part0 = this.currentFrame.parts.get(partId);
            PartConfig part1 = this.nextFrame.parts.get(partId);
            if (part0.isDisable() || !part0.isShow() || part1 == null) {
                this.rotationAngles.put(part0.id, null);
                continue;
            }
            Float[] values = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
            for (int t = 0; t < 3; ++t) {
                for (int a = 0; a < 5; ++a) {
                    float value_1;
                    float value_0;
                    if (t != 0 && a > 2) continue;
                    switch (t) {
                        case 1: {
                            value_0 = part0.offset[a];
                            value_1 = part1.offset[a];
                            break;
                        }
                        case 2: {
                            value_0 = part0.scale[a];
                            value_1 = part1.scale[a];
                            break;
                        }
                        default: {
                            value_0 = part0.rotation[a];
                            value_1 = part1.rotation[a];
                            float result = value_0 - value_1;
                            if ((double)Math.abs(result) > Math.PI) {
                                value_1 = (float)Math.PI * (result < 0.0f ? -2.0f : 2.0f) + value_1;
                            }
                            if (correctorRotations == 1.0f || partId != 1 && partId != 2 && partId != 4 && partId != 5) break;
                            value_0 *= correctorRotations;
                            value_1 *= correctorRotations;
                            break;
                        }
                    }
                    int id = t * 3 + a;
                    if (a > 2) {
                        id = 6 + a;
                    }
                    values[id] = Float.valueOf(this.calcValue(value_0, value_1, this.speedTicks, ticks, this.currentFrame.isSmooth(), partialTicks));
                }
            }
            this.rotationAngles.put(partId, values);
        }
        this.preFrame.resetFrom(this.rotationAngles, this.currentFrame);
    }

    private float calcValue(float value_0, float value_1, float speed, float ticks, boolean isSmooth, float partialTicks) {
        if (speed <= 0.0f || ticks < 0.0f) {
            return value_0;
        }
        float progress = Math.min((ticks + partialTicks) / speed, 1.0f);
        if (progress >= 1.0f) {
            return value_1;
        }
        if (isSmooth) {
            progress = -0.5f * MathHelper.func_76134_b((float)(progress * (float)Math.PI)) + 0.5f;
        }
        return value_0 + (value_1 - value_0) * progress;
    }

    public void load(NBTTagCompound compound) {
        int c;
        if (!compound.func_150297_b("AllAnimations", 9) && !compound.func_150297_b("MovementAnimations", 9)) {
            return;
        }
        this.stopAnimation();
        this.data.clear();
        this.movementAnimation.clear();
        AnimationController aData = AnimationController.getInstance();
        for (c = 0; c < compound.func_150295_c("AllAnimations", 10).func_74745_c(); ++c) {
            AnimationKind type;
            NBTTagCompound nbtCategory = compound.func_150295_c("AllAnimations", 10).func_150305_b(c);
            int t = nbtCategory.func_74762_e("Category");
            if (t < 0) {
                t *= -1;
            }
            if ((type = AnimationKind.get(t % AnimationKind.values().length)) == null) {
                LogWriter.warn("Try load AnimationKind ID:" + t + ". Missed.");
                continue;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            byte tagType = nbtCategory.func_74781_a("Animations").func_74732_a();
            if (tagType == 11) {
                for (int id : nbtCategory.func_74759_k("Animations")) {
                    if (list.contains(id)) continue;
                    list.add(id);
                }
            } else if (tagType == 9) {
                int i;
                int listType = ((NBTTagList)nbtCategory.func_74781_a("Animations")).func_150303_d();
                if (listType == 10 && this.entity != null && this.entity.func_70613_aW()) {
                    for (i = 0; i < nbtCategory.func_150295_c("Animations", 10).func_74745_c(); ++i) {
                        int id;
                        NBTTagCompound nbt = nbtCategory.func_150295_c("Animations", 10).func_150305_b(i);
                        id = nbt.func_74762_e("ID");
                        String name = this.entity.func_70005_c_() + "_" + nbt.func_74779_i("Name");
                        AnimationConfig anim = (AnimationConfig)aData.getAnimation(id);
                        if (this.entity.field_70170_p.func_73045_a(this.entity.func_145782_y()) != null && anim == null || !anim.getName().equals(name)) {
                            boolean found = false;
                            if (anim != null) {
                                for (AnimationConfig ac : aData.animations.values()) {
                                    if (!ac.name.equals(anim.name)) continue;
                                    found = true;
                                    anim = ac;
                                }
                            }
                            if (!found) {
                                anim = (AnimationConfig)aData.createNewAnim();
                                id = anim.id;
                                if (!anim.immutable) {
                                    anim.load(nbt);
                                }
                                anim.name = name;
                                anim.id = id;
                                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.AnimationData, anim.save()});
                            }
                        }
                        if (list.contains(id)) continue;
                        list.add(id);
                    }
                } else if (listType == 3) {
                    for (i = 0; i < nbtCategory.func_150295_c("Animations", 3).func_74745_c(); ++i) {
                        int id = nbtCategory.func_150295_c("Animations", 3).func_186858_c(i);
                        if (list.contains(id)) continue;
                        list.add(id);
                    }
                }
            }
            Collections.sort(list);
            this.data.put(type, list);
        }
        if (compound.func_150297_b("MovementAnimations", 9) && this.entity != null && (this.entity.field_70170_p == null || this.entity.field_70170_p.field_72995_K)) {
            IAnimation anim;
            for (c = 0; c < compound.func_150295_c("MovementAnimations", 10).func_74745_c(); ++c) {
                NBTTagCompound nbt = compound.func_150295_c("MovementAnimations", 10).func_150305_b(c);
                this.movementAnimation.put(AnimationKind.get(nbt.func_74762_e("Type")), nbt.func_74762_e("ID"));
            }
            AnimationKind base = this.getCurrentMovementAnimation();
            if (base != null && (anim = AnimationController.getInstance().getAnimation(this.movementAnimation.get((Object)base))) != null) {
                this.runAnimation((AnimationConfig)anim, base);
                this.stage = EnumAnimationStages.Run;
            }
        }
        this.checkData();
    }

    public void save(NBTTagCompound compound) {
        this.checkData();
        NBTTagList allAnimations = new NBTTagList();
        for (AnimationKind type : this.data.keySet()) {
            if (this.data.get((Object)type) == null || this.data.get((Object)type).isEmpty()) continue;
            NBTTagCompound nbtCategory = new NBTTagCompound();
            nbtCategory.func_74768_a("Category", type.get());
            NBTTagList animations = new NBTTagList();
            for (int id : this.data.get((Object)type)) {
                animations.func_74742_a((NBTBase)new NBTTagInt(id));
            }
            nbtCategory.func_74782_a("Animations", (NBTBase)animations);
            allAnimations.func_74742_a((NBTBase)nbtCategory);
        }
        compound.func_74782_a("AllAnimations", (NBTBase)allAnimations);
        if (this.entity != null && this.entity.field_70170_p != null && !this.entity.field_70170_p.field_72995_K && !this.movementAnimation.isEmpty()) {
            NBTTagList movementAnimations = new NBTTagList();
            for (AnimationKind ak : new ArrayList<AnimationKind>(this.movementAnimation.keySet())) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("Type", ak.ordinal());
                nbt.func_74768_a("ID", this.movementAnimation.get((Object)ak).intValue());
                movementAnimations.func_74742_a((NBTBase)nbt);
            }
            compound.func_74782_a("MovementAnimations", (NBTBase)movementAnimations);
        }
    }

    public boolean isAnimated() {
        boolean isEdit;
        if (this.activeAnimation == null || this.stage == EnumAnimationStages.Waiting) {
            return false;
        }
        if (this.activeAnimation.type == AnimationKind.DIES && this.entity.func_110143_aJ() <= 0.0f) {
            return true;
        }
        boolean bl = isEdit = this.activeAnimation.type == AnimationKind.EDITING_All || this.activeAnimation.type == AnimationKind.EDITING_PART;
        return this.entity.func_70613_aW() ? !this.completeAnimation : this.stage != EnumAnimationStages.Waiting || isEdit || this.activeAnimation.type.isMovement();
    }

    public boolean isAnimated(AnimationKind ... types) {
        if (!this.isAnimated()) {
            return false;
        }
        for (AnimationKind type : types) {
            if (this.activeAnimation.type != type) continue;
            return true;
        }
        return false;
    }

    public void updateTime() {
        boolean isEdit;
        if (this.activeAnimation == null) {
            this.currentFrame = null;
            this.nextFrame = null;
            this.completeAnimation = false;
            this.stage = EnumAnimationStages.Waiting;
            this.startAnimationTime = 0L;
            this.canSetBaseRotationAngles = true;
            this.timeTicks = -1;
            return;
        }
        if (!AnimationController.getInstance().animations.containsKey(this.activeAnimation.id) && this.stage != EnumAnimationStages.Ending && this.stage != EnumAnimationStages.Waiting) {
            this.stage = EnumAnimationStages.Ending;
            this.startAnimationTime = this.entity.field_70170_p.func_82737_E() + 1L;
            return;
        }
        int ticks = Math.max(0, (int)(this.entity.field_70170_p.func_82737_E() - this.startAnimationTime));
        if (this.activeAnimation.type == AnimationKind.EDITING_PART) {
            ticks = this.activeAnimation.editTick;
            if (this.activeAnimation.editFrame > 0) {
                ticks += this.activeAnimation.endingFrameTicks.get(this.activeAnimation.editFrame - 1).intValue();
            }
        }
        boolean bl = isEdit = this.activeAnimation.type == AnimationKind.EDITING_All || this.activeAnimation.type == AnimationKind.EDITING_PART;
        if (!isEdit && this.activeAnimation.type.isMovement() && this.stage != EnumAnimationStages.Ending && this.stage != EnumAnimationStages.Waiting) {
            if (!this.movementAnimation.containsKey((Object)this.activeAnimation.type)) {
                this.stage = EnumAnimationStages.Ending;
                this.startAnimationTime = this.entity.field_70170_p.func_82737_E() + 1L;
                return;
            }
            boolean isMoving = Util.instance.isMoving(this.entity);
            boolean isWalk = this.activeAnimation.type.name().toLowerCase().contains("walk");
            if (isWalk != isMoving) {
                this.stage = EnumAnimationStages.Ending;
                this.startAnimationTime = this.entity.field_70170_p.func_82737_E() + 1L;
                return;
            }
            boolean isRav = this.activeAnimation.type.name().toLowerCase().contains("revenge");
            if (isRav) {
                boolean stop = false;
                if (this.entity instanceof EntityPlayer) {
                    if (this.entity.func_142013_aG() - this.entity.field_70173_aa > 300) {
                        stop = true;
                    }
                } else {
                    boolean bl2 = stop = !((EntityNPCInterface)this.entity).isAttacking();
                }
                if (stop) {
                    this.stage = EnumAnimationStages.Ending;
                    this.startAnimationTime = this.entity.field_70170_p.func_82737_E() + 1L;
                    return;
                }
            }
        }
        if (this.stage == EnumAnimationStages.Started) {
            int speed;
            int n = speed = this.activeAnimation.type.isQuickStart() ? 4 : 10;
            if (ticks == 0) {
                this.startEvent(new AnimationEvent.StartEvent(this.entity, this.activeAnimation, -1, 0L, EnumAnimationStages.Started));
            } else {
                this.startEvent(new AnimationEvent.UpdateEvent(this.entity, this.activeAnimation, -1, ticks, EnumAnimationStages.Started));
            }
            if (ticks >= speed) {
                this.startAnimationTime += (long)(speed + 1);
                this.stage = EnumAnimationStages.Run;
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Looping) {
            int speed = this.activeAnimation.frames.get((Object)Integer.valueOf((int)(this.activeAnimation.frames.size() - 1))).speed;
            if (ticks == 0) {
                this.startEvent(new AnimationEvent.StartEvent(this.entity, this.activeAnimation, -1, 0L, EnumAnimationStages.Looping));
            } else {
                this.startEvent(new AnimationEvent.UpdateEvent(this.entity, this.activeAnimation, -1, ticks, EnumAnimationStages.Looping));
            }
            if (ticks >= speed) {
                int lastFrameId = this.activeAnimation.frames.size();
                int frameId = 0;
                if (this.activeAnimation.repeatLast > 0) {
                    frameId = ValueUtil.correctInt(lastFrameId - this.activeAnimation.repeatLast, 0, lastFrameId - 1);
                } else if (this.activeAnimation.type == AnimationKind.DIES) {
                    frameId = lastFrameId - 1;
                }
                this.startAnimationTime = frameId == 0 ? this.entity.field_70170_p.func_82737_E() + 1L : this.entity.field_70170_p.func_82737_E() + (long)this.activeAnimation.endingFrameTicks.get(frameId - 1).intValue() + 1L;
                if (frameId != lastFrameId - 1) {
                    this.stage = EnumAnimationStages.Run;
                }
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Run) {
            int animationFrame;
            this.canSetBaseRotationAngles = false;
            if (ticks == 0) {
                AnimationKind type = this.activeAnimation.type.getParentEnum() != null ? this.activeAnimation.type.getParentEnum() : this.activeAnimation.type;
                boolean bl3 = this.isCyclical = this.activeAnimation.repeatLast > 0 || type == AnimationKind.JUMP && this.isJump || type.isMovement() && (isEdit || this.activeAnimation.chance >= 1.0f) || type == AnimationKind.DIES && (isEdit || this.entity.func_110143_aJ() <= 0.0f);
            }
            if ((animationFrame = this.activeAnimation.getAnimationFrameByTime(ticks)) < this.activeAnimation.frames.size() - 1) {
                int frameTime;
                int startFrameTime = 0;
                if (this.activeAnimation.endingFrameTicks.containsKey(animationFrame - 1)) {
                    startFrameTime = this.activeAnimation.endingFrameTicks.get(animationFrame - 1);
                }
                if ((frameTime = ticks - startFrameTime) == 0) {
                    this.startEvent(new AnimationEvent.NextFrameEvent(this.entity, this.activeAnimation, animationFrame, 0L, EnumAnimationStages.Run));
                } else {
                    this.startEvent(new AnimationEvent.UpdateEvent(this.entity, this.activeAnimation, animationFrame, frameTime, EnumAnimationStages.Run));
                }
            } else {
                this.startAnimationTime = this.entity.field_70170_p.func_82737_E() + 1L;
                if (this.activeAnimation.type != AnimationKind.EDITING_PART) {
                    this.stage = this.isCyclical ? EnumAnimationStages.Looping : EnumAnimationStages.Ending;
                    this.canSetBaseRotationAngles = true;
                }
                this.completeAnimation = true;
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Ending) {
            int speed;
            this.canSetBaseRotationAngles = true;
            int n = speed = this.activeAnimation.type.isQuickStart() ? 4 : 10;
            if (ticks == 0) {
                this.startEvent(new AnimationEvent.StartEvent(this.entity, this.activeAnimation, -1, 0L, EnumAnimationStages.Ending));
            } else {
                this.startEvent(new AnimationEvent.UpdateEvent(this.entity, this.activeAnimation, -1, ticks, EnumAnimationStages.Ending));
            }
            if (ticks >= speed) {
                if (this.activeAnimation.type == AnimationKind.EDITING_All) {
                    this.startAnimationTime = this.entity.field_70170_p.func_82737_E() + 1L;
                    this.stage = EnumAnimationStages.Started;
                } else {
                    this.startAnimationTime = 0L;
                    this.stage = EnumAnimationStages.Waiting;
                }
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Waiting) {
            this.canSetBaseRotationAngles = true;
            this.stopAnimation();
        }
    }

    private void startEvent(AnimationEvent event) {
        PlayerData data;
        if (event == null || event.animation != null && (event.animation.type == AnimationKind.EDITING_All || event.animation.type == AnimationKind.EDITING_PART)) {
            return;
        }
        if (event instanceof AnimationEvent.UpdateEvent && this.entity.func_70613_aW()) {
            return;
        }
        IScriptHandler handler = null;
        if (!this.entity.func_70613_aW()) {
            handler = ScriptController.Instance.clientScripts;
        } else if (this.entity instanceof EntityNPCInterface) {
            handler = ((EntityNPCInterface)this.entity).script;
        } else if (this.entity instanceof EntityPlayer && (data = PlayerData.get((EntityPlayer)this.entity)) != null) {
            handler = data.scriptData;
        }
        if (handler != null) {
            EventHooks.onEvent(handler, event.nameEvent, (Event)event);
        }
    }

    public AnimationConfig selectAnimation(AnimationKind type) {
        if (!CustomNpcs.ShowCustomAnimation || this.data.get((Object)type) == null || this.data.get((Object)type).isEmpty()) {
            return null;
        }
        List<AnimationConfig> list = AnimationController.getInstance().getAnimations(this.data.get((Object)type));
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<AnimationConfig> selectList = new ArrayList<AnimationConfig>();
        for (AnimationConfig ac : list) {
            if (this.waitData.containsKey(ac.id) && this.waitData.get(ac.id) > System.currentTimeMillis()) continue;
            if (ac.chance <= this.rnd.nextFloat()) {
                if (type.isQuickStart()) continue;
                this.waitData.put(ac.id, System.currentTimeMillis() + (long)((1.0f - ac.chance) * 10000.0f));
                continue;
            }
            selectList.add(ac);
        }
        AnimationConfig anim = null;
        if (!selectList.isEmpty()) {
            anim = ((AnimationConfig)selectList.get(this.rnd.nextInt(selectList.size()))).copy();
        }
        if (anim == null && type.isQuickStart() && !list.isEmpty()) {
            anim = list.get(this.rnd.nextInt(list.size())).copy();
        }
        return anim;
    }

    public AnimationConfig tryRunAnimation(AnimationConfig anim, AnimationKind type) {
        if (anim == null || anim.frames.isEmpty()) {
            return null;
        }
        this.runAnimation(anim, type);
        this.isJump = type == AnimationKind.JUMP;
        boolean bl = this.isSwing = type == AnimationKind.SWING;
        if (type == AnimationKind.DIES) {
            this.entity.field_70159_w = 0.0;
            this.entity.field_70181_x = 0.0;
            this.entity.field_70179_y = 0.0;
        }
        return this.activeAnimation;
    }

    private void runAnimation(AnimationConfig anim, AnimationKind type) {
        boolean isEdit;
        boolean bl = isEdit = type == AnimationKind.EDITING_All || type == AnimationKind.EDITING_PART;
        if (this.entity.func_70613_aW() && isEdit) {
            return;
        }
        type.setEditingBooleans(anim.type);
        if (this.activeAnimation != null && !isEdit && this.activeAnimation.id == anim.id && type != AnimationKind.ATTACKING && type != AnimationKind.HIT && type != AnimationKind.SHOOT && type != AnimationKind.SWING && type != AnimationKind.BLOCKED) {
            return;
        }
        this.activeAnimation = anim.copy();
        this.activeAnimation.editTick = anim.editTick;
        this.activeAnimation.editFrame = anim.editFrame;
        this.activeAnimation.type = type;
        this.stage = EnumAnimationStages.Started;
        if (type == AnimationKind.EDITING_PART) {
            this.stage = EnumAnimationStages.Run;
        }
        this.startAnimationTime = this.entity.field_70170_p.func_82737_E();
        this.completeAnimation = false;
        this.calculationAnimationData(0.0f);
    }

    public Map<Integer, Integer> resetWalkAndStandAnimations() {
        if (!this.entity.func_70613_aW() || this.activeAnimation != null && !this.completeAnimation) {
            return null;
        }
        boolean isChanged = false;
        for (AnimationKind ak : AnimationKind.values()) {
            if (!ak.isMovement()) continue;
            if (this.data.get((Object)ak) != null && !this.data.get((Object)ak).isEmpty()) {
                AnimationConfig anim = this.selectAnimation(ak);
                if (anim == null || this.movementAnimation.containsKey((Object)ak) && anim.id == this.movementAnimation.get((Object)ak)) continue;
                this.movementAnimation.put(ak, anim.id);
                isChanged = true;
                continue;
            }
            if (!this.movementAnimation.containsKey((Object)ak)) continue;
            this.movementAnimation.remove((Object)ak);
            isChanged = true;
        }
        if (!isChanged) {
            return null;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (AnimationKind ak : new ArrayList<AnimationKind>(this.movementAnimation.keySet())) {
            map.put(ak.ordinal(), this.movementAnimation.get((Object)ak));
        }
        return map;
    }

    public void loadBaseAnimations(Map<Object, Object> map) {
        AnimationController aData = AnimationController.getInstance();
        this.movementAnimation.clear();
        for (Object key : map.keySet()) {
            AnimationConfig anim;
            if (!(key instanceof Integer) || !(map.get(key) instanceof Integer) || (anim = aData.animations.get((int)((Integer)map.get(key)))) == null) continue;
            this.movementAnimation.put(AnimationKind.get((Integer)key), anim.id);
        }
    }

    public void setRotationAngles(float ignoredLimbSwing, float ignoredLimbSwingAmount, float ignoredAgeInTicks, float ignoredNetHeadYaw, float ignoredHeadPitch, float ignoredScaleFactor, float partialTicks) {
        IAnimation anim;
        AnimationKind base = this.getCurrentMovementAnimation();
        if (base != null && (this.activeAnimation == null || this.activeAnimation.type.isMovement() && this.activeAnimation.id != this.movementAnimation.get((Object)base)) && (anim = AnimationController.getInstance().getAnimation(this.movementAnimation.get((Object)base))) != null && (!this.waitData.containsKey(anim.getId()) || this.waitData.get(anim.getId()) <= System.currentTimeMillis())) {
            if (anim.getChance() <= this.rnd.nextFloat()) {
                this.waitData.put(anim.getId(), System.currentTimeMillis() + 1000L);
            } else {
                this.tryRunAnimation((AnimationConfig)anim, base);
            }
        }
        if (this.isAnimated()) {
            this.calculationAnimationData(partialTicks);
        }
    }

    private AnimationKind getCurrentMovementAnimation() {
        AnimationKind base = null;
        boolean isMoving = Util.instance.isMoving(this.entity);
        if (!this.movementAnimation.isEmpty() && (this.activeAnimation == null || isMoving)) {
            if (this.movementAnimation.containsKey((Object)AnimationKind.AIM) && !isMoving) {
                int currentAnimation;
                if (this.entity instanceof EntityPlayer) {
                    if (this.entity.func_184607_cu().func_77973_b() instanceof ItemBow) {
                        base = AnimationKind.AIM;
                    }
                } else if (((EntityNPCInterface)this.entity).isAttacking() && ((currentAnimation = ((EntityNPCInterface)this.entity).currentAnimation) == 6 || currentAnimation == 11 || ((EntityNPCInterface)this.entity).stats.ranged.getHasAimAnimation()) && ((EntityNPCInterface)this.entity).inventory.getProjectile() != null) {
                    base = AnimationKind.AIM;
                }
            }
            if (base == null) {
                if (this.entity instanceof EntityPlayer) {
                    if (this.entity.func_142013_aG() - this.entity.field_70173_aa < 300) {
                        base = isMoving ? AnimationKind.REVENGE_WALK : AnimationKind.REVENGE_STAND;
                    }
                } else if (((EntityNPCInterface)this.entity).isAttacking()) {
                    base = isMoving ? AnimationKind.REVENGE_WALK : AnimationKind.REVENGE_STAND;
                }
                if (base != null && !this.movementAnimation.containsKey((Object)base)) {
                    base = null;
                }
            }
            if (base == null) {
                if (this.entity.field_70122_E && !this.movementAnimation.containsKey((Object)(base = isMoving ? AnimationKind.WALKING : AnimationKind.STANDING))) {
                    base = null;
                }
                if (base == null) {
                    if (this.entity instanceof EntityPlayer) {
                        if (((EntityPlayer)this.entity).field_71075_bZ.field_75101_c) {
                            base = isMoving ? AnimationKind.FLY_WALK : AnimationKind.FLY_STAND;
                        }
                    } else if (((EntityNPCInterface)this.entity).ais.getNavigationType() == 1) {
                        base = isMoving ? AnimationKind.FLY_WALK : AnimationKind.FLY_STAND;
                    }
                    if (!this.movementAnimation.containsKey((Object)base)) {
                        base = null;
                    }
                }
                if (base == null) {
                    if ((this.entity.func_70090_H() || this.entity.func_180799_ab() || this.entity.field_70170_p.func_72875_a(this.entity.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151586_h)) && !this.movementAnimation.containsKey((Object)(base = isMoving ? AnimationKind.WATER_WALK : AnimationKind.WATER_STAND))) {
                        base = null;
                    }
                    if (base == null && this.entity instanceof EntityNPCInterface && ((EntityNPCInterface)this.entity).ais.getNavigationType() == 2 && !this.movementAnimation.containsKey((Object)(base = isMoving ? AnimationKind.WATER_WALK : AnimationKind.WATER_STAND))) {
                        base = null;
                    }
                }
                if (base == null && this.movementAnimation.containsKey((Object)AnimationKind.BASE)) {
                    base = AnimationKind.BASE;
                }
            }
        }
        return base;
    }

    public void addAnimation(AnimationKind type, int id) {
        this.data.get((Object)type).add(id);
    }

    public boolean removeAnimation(AnimationKind type, int id) {
        return this.data.get((Object)type).remove((Object)id);
    }

    public boolean hasAnimation(AnimationKind type, int id) {
        return this.data.get((Object)type).contains(id);
    }

    public boolean canSetBaseRotationAngles() {
        return this.canSetBaseRotationAngles;
    }

    public boolean canBeAnimated() {
        return this.stage != EnumAnimationStages.Waiting || !this.movementAnimation.isEmpty() && (this.activeAnimation == null || this.activeAnimation.type.isMovement()) && this.entity.field_70170_p.func_82737_E() % 3L == 0L;
    }

    public ItemStack getCurrentHeldStack(boolean isMainHand) {
        if (!this.isAnimated()) {
            return null;
        }
        IItemStack iStack = null;
        switch (isMainHand ? this.currentFrame.getHoldRightStackType() : this.currentFrame.getHoldLeftStackType()) {
            case 0: {
                return isMainHand ? this.entity.func_184614_ca() : this.entity.func_184592_cb();
            }
            case 1: {
                if (this.entity instanceof EntityPlayer) {
                    return new ItemStack(Items.field_151032_g);
                }
                iStack = ((EntityNPCInterface)this.entity).inventory.getProjectile();
                break;
            }
            case 2: {
                return isMainHand ? this.entity.func_184592_cb() : this.entity.func_184614_ca();
            }
            case 3: {
                iStack = isMainHand ? this.currentFrame.getHoldRightStack() : this.currentFrame.getHoldLeftStack();
                break;
            }
            case 4: {
                return this.entity.func_184582_a(EntityEquipmentSlot.HEAD);
            }
            case 5: {
                return this.entity.func_184582_a(EntityEquipmentSlot.CHEST);
            }
            case 6: {
                return this.entity.func_184582_a(EntityEquipmentSlot.LEGS);
            }
            case 7: {
                return this.entity.func_184582_a(EntityEquipmentSlot.FEET);
            }
        }
        return iStack == null ? (isMainHand ? this.entity.func_184614_ca() : this.entity.func_184592_cb()) : iStack.getMCItemStack();
    }

    public int getAnimationCurrentFrameID() {
        if (this.activeAnimation == null || this.currentFrame == null) {
            return -1;
        }
        return this.currentFrame.id;
    }

    public int getAnimationNextFrameID() {
        if (this.activeAnimation == null || this.nextFrame == null) {
            return -1;
        }
        return this.nextFrame.id;
    }

    public int getAnimationTicks() {
        return this.timeTicks;
    }

    public int getAnimationSpeedTicks() {
        return this.speedTicks;
    }
}

